/*************************************************/
/* Examples Program For "ET-dsPIC30F2010"  Board */
/* Hardware    : ET-dsPIC30F2010 TRAINING KIT V1 */
/* Target MCU  : dsPIC30F2010                    */
/*       	   : X-TAL : 7.3728 MHz              */
/*             : Run 117.9648MHz                 */
/*             : Selec OSC Mode = XT w/PLL 16x   */
/* Compiler    : MPLAB + C30 V1.33  		     */
/* Last Update : 1/October/2005                  */
/* Function    : Example Use RB0 on Output Mode  */
/*             : LED Blink on RB0                */	
/*************************************************/

#include "p30f2010a2.h"                                		// dsPIC30F2010 MPU Register

/* Setup Configuration For ET-dsPIC30F2010 */
_FOSC(CSW_FSCM_ON & XT_PLL16);								// Enable Clock Switching,Enable Fail-Salf Clock
                                                            // Closk Source = Primary XT + (PLL x 16)
_FWDT(WDT_OFF);												// Disable Watchdog 
_FBORPOR(PBOR_ON & BORV_45 & PWRT_64 & MCLR_EN);			// Enable Brown-Out = 4.5V,Power ON = 64mS,Enable MCLR
_FGS(CODE_PROT_OFF);										// Code Protect OFF
/* End   Configuration For ET-dsPIC30F2010 */

/* pototype  section */
void delay_led(unsigned long int);							// Delay Time Function

int main(void)
{  
  TRISBbits.TRISB0 = 0;										// Config RB0 = Output
  
  // Loop Blink LED on RB0 //
  while(1)													// Loop Continue
  {
    LATBbits.LATB0 = !LATBbits.LATB0; 						// Toggle Output RB0 (0 = ON LED, 1 = OFF LED)
	delay_led(1000000);	   									// Display LED Delay
  }   
}	  

/***********************/
/* Delay Time Function */
/*    1-4294967296     */
/***********************/
void delay_led(unsigned long int count1)
{
  while(count1 > 0) {count1--;}								// Loop Decrease Counter	
}
